# Official Windows Release Versions

This archive contains the **Windows release versions** of the following tools:

- **ACF Plugin** (1.7.8.1) – FileMaker plugin with the ACF scripting language and functions
- **ACFcompiler** (1.7.8.1) – standalone command-line compiler for ACF scripts
- **DDRparser** (1.4.1) – command-line tool for analyzing and exporting FileMaker DDR/SaveAsXML
- FileMaker **DDR-GUI-Tools.fmp12** – a helper file that lets you select DDR files and set options to generate DDRparser commands for you

All four applications are included in this ZIP archive.

------

All applications and installers are now signed with our new trusted, official code-signing certificate. Therefore, they should no longer trigger Windows SmartScreen protection.
 As part of the required code-signing procedure, all apps and installers are also scanned for malware before being signed. This guarantees that they are released in their original form by **HORNEKS ANS, Norway**, and have never been tampered with.

------

## **Step 1 – Install the ACF Plugin (FileMaker)**

1. Open FileMaker (but not a database).
2. Go to **Edit → Preferences**.
3. Open the **Plugins** tab.
4. Click **Reveal plugin folder**.
5. Copy **`ACF-Plugin.fmx64`** into that folder (overwrite if prompted).
6. Restart FileMaker and check the Preferences panel — the ACF Plugin should now appear in the list.

The plugin will run in **trial mode** for 30 minutes at a time unless you have a license. (The translation functions `_("…")` and `_n("…")` remain available without a license.)

For uninterrupted use, you can purchase a license from our shop:
 👉 https://horneks.no/butikk

------

## **Step 2 – ACFcompiler and DDRparser**

Both tools are command-line applications. Run the installer for each to install the applications.

- **ACFcompiler**: Compile and check ACF scripts outside FileMaker. (If you edit ACF code in Sublime Text, you can build with **Control-B** to check for syntax errors before loading the code into FileMaker.)
- **DDRparser**: Parse and export FileMaker DDR/SaveAsXML reports into structured files for diffing, searching, and version control.
   DDRparser also includes tools for building multilingual FileMaker applications alongside the ACF Plugin. The included GUI tool demonstrates how this can be done.

Each tool comes with its own documentation and help options. For more details:

- [ACF Manual](https://horneks.no/manuals/ACF/index.html)
- [DDRparser Page](https://horneks.no/ddrparser)

------

## **Final Notes**

Our mission is to create smart tools and solutions for the FileMaker community — accelerating development and making the unthinkable possible.

------

**Best regards,**
 Ole Kristian Ek Hornnes
 System Consultant / Developer
 📞 983 55 884 | ✉️ [ole@horneks.no
